<?php
require __DIR__ . '/config.php';
cors();
if (!isset($_SESSION['admin'])) {
  header('Location: auth.php');
  exit;
}
$data = read_data();
$csrf = $_SESSION['csrf'] ?? bin2hex(random_bytes(16));
$_SESSION['csrf'] = $csrf;
?>
<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>Dashboard</title>
  <link rel="icon" href="https://cdn-icons-png.flaticon.com/128/10484/10484590.png">
  <script src="https://cdn.tailwindcss.com"></script>
  <style>
    body {
      background-image:url('https://static.vecteezy.com/system/resources/previews/023/654/784/non_2x/golden-logo-template-free-png.png');
      background-size:cover;
      background-position:center;
      background-attachment:fixed;
      min-height:100vh;
      margin:0; padding:0;
      font-family: system-ui, -apple-system, 'Outfit', sans-serif;
      filter: brightness(1.18) contrast(1.08);
    }
    .overlay {
      background: rgba(15,23,42,0.35);
      min-height:100vh; width:100%;
      display:flex; flex-direction:column; align-items:center;
      padding:32px 16px 40px;
    }
    .card {
      background: rgba(0,0,0,0.93);
      border-radius:14px;
      box-shadow:0 0 25px rgba(255, 215, 0, 0.08);
    }
    input, .item {
      background:#0d0d0d;
      border:1px solid #1f2937;
      color:#f1f5f9;
    }
    input::placeholder { color:#64748b; }
    .btn-gold {
      background: linear-gradient(90deg, #ffcc33 0%, #ffb700 50%, #ffcc33 100%);
      color:#000; font-weight:700; letter-spacing:.2px;
      box-shadow: 0 0 15px rgba(255, 200, 0, 0.45);
      border:none; transition:all .15s;
    }
    .btn-gold:hover {
      background: linear-gradient(90deg, #ffe45c 0%, #ffb700 100%);
      transform: translateY(-1px);
      box-shadow: 0 0 22px rgba(255, 230, 120, 0.6);
    }
    h2 { color:#ffcc33; letter-spacing:.4px; }
    a { color:#e5e7eb; }
    a:hover { color:#ffd84d; }
    .status { font-size:.85rem; margin-top:.25rem; }
  </style>
</head>
<body class="text-white">
  <div class="overlay">
    <div class="grid grid-cols-1 md:grid-cols-2 gap-8 max-w-6xl w-full card p-6 md:p-10">
      <!-- LOGIN -->
      <section>
        <h2 class="text-xl font-semibold mb-3">LOGIN</h2>
        <div class="flex gap-2 mb-3">
          <input id="loginInput" class="flex-1 px-3 py-2 rounded outline-none" placeholder="Tambah link login">
          <button class="px-4 py-2 rounded btn-gold" onclick="addLink('login')">Tambah</button>
        </div>
        <ul id="loginList" class="space-y-2">
          <?php foreach(($data['login'] ?? []) as $u): ?>
            <li class="item px-3 py-2 rounded">
              <div class="flex justify-between items-center gap-3">
                <a class="truncate hover:underline" href="<?= htmlspecialchars($u) ?>" target="_blank"><?= htmlspecialchars($u) ?></a>
                <button class="text-red-400" onclick="delLink('login','<?= htmlspecialchars($u, ENT_QUOTES) ?>')">Hapus</button>
              </div>
              <div class="status text-slate-300">Belum dicek</div>
            </li>
          <?php endforeach; ?>
        </ul>
        <button class="w-full mt-4 py-2 rounded btn-gold" onclick="checkNawala('login')">CHECK LINK NAWALA</button>
      </section>

      <!-- DAFTAR -->
      <section>
        <h2 class="text-xl font-semibold mb-3">DAFTAR</h2>
        <div class="flex gap-2 mb-3">
          <input id="daftarInput" class="flex-1 px-3 py-2 rounded outline-none" placeholder="Tambah link daftar">
          <button class="px-4 py-2 rounded btn-gold" onclick="addLink('daftar')">Tambah</button>
        </div>
        <ul id="daftarList" class="space-y-2">
          <?php foreach(($data['daftar'] ?? []) as $u): ?>
            <li class="item px-3 py-2 rounded">
              <div class="flex justify-between items-center gap-3">
                <a class="truncate hover:underline" href="<?= htmlspecialchars($u) ?>" target="_blank"><?= htmlspecialchars($u) ?></a>
                <button class="text-red-400" onclick="delLink('daftar','<?= htmlspecialchars($u, ENT_QUOTES) ?>')">Hapus</button>
              </div>
              <div class="status text-slate-300">Belum dicek</div>
            </li>
          <?php endforeach; ?>
        </ul>
        <button class="w-full mt-4 py-2 rounded btn-gold" onclick="checkNawala('daftar')">CHECK LINK NAWALA</button>
      </section>
    </div>

    <a href="logout.php" class="mt-6 text-slate-300 hover:underline">Logout</a>
  </div>

  <script>
    const CSRF = "<?= $csrf ?>";

    async function reloadData(){ location.reload(); }

    async function addLink(type){
      const input = document.getElementById(type + 'Input');
      const url = input.value.trim();
      if(!url) return;
      await fetch('api.php?action=add', {
        method:'POST',
        headers:{'Content-Type':'application/json','X-CSRF':CSRF},
        body: JSON.stringify({type, url})
      });
      input.value = '';
      reloadData();
    }

    async function delLink(type, url){
      await fetch('api.php?action=del', {
        method:'POST',
        headers:{'Content-Type':'application/json','X-CSRF':CSRF},
        body: JSON.stringify({type, url})
      });
      reloadData();
    }

    function normalize(u){ try{ return new URL(u).href; }catch{ return u; } }

    async function checkNawala(type){
      const items = Array.from(document.querySelectorAll('#' + type + 'List li'));
      const links = items.map(li => li.querySelector('a')?.href).filter(Boolean);

      items.forEach(li => {
        const s = li.querySelector('.status');
        if (s) s.textContent = 'Memeriksa...';
      });

      try {
        const resp = await fetch('check_nawala.php', {
          method: 'POST',
          headers: {'Content-Type':'application/json'},
          body: JSON.stringify({links})
        });
        const data = await resp.json();
        const m = new Map();
        (data.results || []).forEach(r => m.set(normalize(r.url), r));

        items.forEach(li => {
          const a = li.querySelector('a');
          const s = li.querySelector('.status');
          if(!a || !s) return;
          const r = m.get(normalize(a.href));
          if (!r) { s.innerHTML = '<span class="text-slate-300">Tidak ada hasil</span>'; return; }

          const status = (r.status || '').toLowerCase();

          if (['ok', 'safe', 'allowed'].includes(status)) {
            s.innerHTML = '<span class="text-green-400">✅ Aman</span>';
          } else if (['blocked', 'nawala', 'blacklist'].includes(status)) {
            s.innerHTML = '<span class="text-red-400">❌ Diblokir (Nawala)</span>';
          } else if (status === 'error') {
            s.innerHTML = '<span class="text-orange-400">⚠ Gagal memeriksa</span>';
          } else {
            s.innerHTML = '<span class="text-yellow-300">⚠ Unknown</span>';
          }
        });
      } catch (err) {
        alert('Gagal menghubungi API: ' + err.message);
      }
    }
  </script>
</body>
</html>
