<?php
header('Content-Type: application/json');
header('Cache-Control: no-cache, no-store, must-revalidate');
header('Pragma: no-cache');
header('Expires: 0');

$apiToken = '211aef382682788cdfb9668c1845a866';
$apiBase  = 'https://indiwtf.com/api/check';

$input = json_decode(file_get_contents('php://input'), true);

if (!isset($input['links']) || !is_array($input['links'])) {
    echo json_encode(['ok' => false, 'error' => 'Input tidak valid, kirim {"links": [...]}']);
    exit;
}

$results = [];
foreach ($input['links'] as $link) {
    $domain = parse_url($link, PHP_URL_HOST);
    if (!$domain) $domain = $link;

    $url = $apiBase . '?domain=' . urlencode($domain) . '&token=' . urlencode($apiToken);

    $ch = curl_init($url);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT => 10,
        CURLOPT_SSL_VERIFYPEER => false
    ]);
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    if ($httpCode === 200 && $response) {
        $data = json_decode($response, true);
        $status = isset($data['status']) ? $data['status'] : 'unknown';
        $ips = isset($data['ip']) ? (array)$data['ip'] : [];

        $results[] = [
            'url' => $link,
            'domain' => $domain,
            'status' => strtolower($status),
            'ips' => $ips
        ];
    } else {
        $results[] = [
            'url' => $link,
            'domain' => $domain,
            'status' => 'error',
            'ips' => []
        ];
    }
}

echo json_encode(['ok' => true, 'results' => $results], JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT);
