<?php
require __DIR__ . '/config.php';
cors();

header('Content-Type: application/json');

if (empty($_SESSION['admin'])) {
  http_response_code(401);
  echo json_encode(['ok' => false, 'msg' => 'unauthorized']);
  exit;
}

$action = $_GET['action'] ?? '';
$body = json_decode(file_get_contents('php://input'), true) ?: [];

if (in_array($action, ['add', 'del'], true)) {
  check_csrf();
}

$data = read_data();

function normalize($u) {
  $u = trim($u);
  if (!preg_match('~^https?://~i', $u)) $u = 'https://' . $u;
  return $u;
}

switch ($action) {
  case 'add':
    $type = $body['type'] ?? '';
    $url  = normalize($body['url'] ?? '');
    if (!in_array($type, ['login', 'daftar'], true) || !filter_var($url, FILTER_VALIDATE_URL)) {
      echo json_encode(['ok' => false, 'msg' => 'Input tidak valid']);
      exit;
    }
    if (!in_array($url, $data[$type], true)) {
      $data[$type][] = $url;
      write_data($data);
    }
    echo json_encode(['ok' => true]);
    break;

  case 'del':
    $type = $body['type'] ?? '';
    $url  = normalize($body['url'] ?? '');
    if (!in_array($type, ['login', 'daftar'], true)) {
      echo json_encode(['ok' => false]);
      exit;
    }
    $data[$type] = array_values(array_filter($data[$type], fn($x) => $x !== $url));
    write_data($data);
    echo json_encode(['ok' => true]);
    break;

  case 'check':
    $type = $_GET['type'] ?? 'login';
    $list = $data[$type] ?? [];
    $out = [];
    foreach ($list as $u) {
      $ctx = stream_context_create(['http' => ['method' => 'HEAD', 'timeout' => 5, 'ignore_errors' => true]]);
      $f = @fopen($u, 'r', false, $ctx);
      $status = $http_response_header[0] ?? 'NO RESPONSE';
      if ($f) fclose($f);
      $out[] = ['url' => $u, 'status' => $status];
    }
    echo json_encode(['ok' => true, 'results' => $out]);
    break;

  default:
    echo json_encode(['ok' => false, 'msg' => 'Unknown action']);
    break;
}
